<?php

/* @var $this yii\web\View */
/* @var $form yii\bootstrap\ActiveForm */
/* @var $model \common\models\LoginForm */

use yii\helpers\Html;
use yii\bootstrap\ActiveForm;

$myAssetBundle = bitcream\skin\bitcream\backend\Asset::register($this);

$this->title = 'Login';
?>
<div class="site-login">
    <div class="login-wrapper">
        <div class="brand-wrapper">
            <img src="<?= $myAssetBundle->baseUrl . '/images/gmv-logo-white.svg'; ?>" width="150" />
        </div>
        <div class="login-inner">
                <h1><?= Html::encode($this->title) ?></h1>
                <p><?=Yii::t('app', 'Please fill out the following fields to login:')?></p>

                <?php $form = ActiveForm::begin(['id' => 'login-form']); ?>

                    <?= $form->field($model, 'username')->textInput(['autofocus' => true]) ?>

                    <?= $form->field($model, 'password')->passwordInput() ?>

                    <?= $form->field($model, 'rememberMe')->checkbox() ?>

                    <div class="form-group">
                        <?= Html::submitButton('Login', ['class' => 'btn btn-primary btn-lg btn-block', 'name' => 'login-button']) ?>
                    </div>
                    <div class="other-links">
                        <p><?=Yii::t('app', 'Forgot password?')?> <?= Html::a('Reset password', ['/site/request-password-reset']) ?></p>
                    </div>
            </div>
        </div>
    </div>
        <?php ActiveForm::end(); ?>
</div>