<?php

namespace bitcream\gmvricambi\custom\api\controllers;

use yii\rest\ActiveController;
use bitcream\gmvricambi\custom\api\models\Order;
use Yii;
use yii\db\Query;
use yii\data\ActiveDataFilter;
use yii\data\ActiveDataProvider;
 
class OrderController extends ActiveController
{
    public $modelClass = 'bitcream\gmvricambi\custom\api\models\Order';

    public function actions(){
        $actions = parent::actions();

        $actions['index']['prepareDataProvider'] = [$this, 'prepareDataProvider'];

        return $actions;
    }

    public function prepareDataProvider(){

        $filter = new ActiveDataFilter([
            'searchModel' => 'bitcream\gmvricambi\custom\api\models\OrderSearch'
        ]);
        
        $filterCondition = null;
        
        // You may load filters from any source. For example,
        // if you prefer JSON in request body,
        // use Yii::$app->request->getBodyParams() below:
        if ($filter->load(\Yii::$app->request->get())) { 
            $filterCondition = $filter->build();
            if ($filterCondition === false) {
                // Serializer would get errors out of it
                return $filter;
            }
        }
        $query = Order::find();
        
        $query->andFilterWhere(['id' => Yii::$app->params['orderActive']]);
        
        return new ActiveDataProvider([
            'query' => $query,
        ]);
    }   
}
