<?php

namespace bitcream\gmvricambi\custom\api\models;

use Yii;
/**
 * This is the model class for table "{{%gmv-customer}}".
 *
 */
class GMVArticle extends \bitcream\gmvricambi\custom\common\models\GMVArticle
{
    public function fields(){
        return [
            'article_cod',
            'description',
            'family',
            'unit_of_measure_cod',
            'unit_of_measure',
            'weight',
            'packaging_code',
            'assembled_product',
        ];
    }

    /**
     * Gets query for [[Orders]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getProducts()
    {
        return $this->hasMany(Product::className(), ['article_cod' => 'article_cod'])->inverseOf('GMVArticle');
    }

}
