<?php

namespace bitcream\gmvricambi\custom\api\models;

use Yii;
/**
 * This is the model class for table "{{%product}}".
 *
 */
class Product extends \bitcream\gmvricambi\custom\common\models\Product
{
    public function fields(){
        return [
            'id',
            'name',
            'slug',
            'description',
            'detail',
            'cover_image',
            'cost',
            'weight',
            'size',
            //'gmv_article' => 'articleCod',
            'category' => 'category',
        ];
    }

    /**
     * Gets query for [[ArticleCod]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getArticleCod()
    {
        return $this->hasOne(GMVArticle::className(), ['article_cod' => 'article_cod'])->inverseOf('products');
    }

    /**
     * Gets query for [[Category]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCategory()
    {
        return $this->hasOne(Category::className(), ['id' => 'category_id'])->inverseOf('products');
    }

}
