<?php

namespace bitcream\gmvricambi\custom\backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use bitcream\gmvricambi\custom\backend\models\GMVDiscount;

/**
 * GMVDiscountSearch represents the model behind the search form of `bitcream\gmvricambi\custom\backend\models\GMVDiscount`.
 */
class GMVDiscountSearch extends GMVDiscount
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['customer_cod', 'family'], 'safe'],
            [['discount_1', 'discount_2', 'discount_3', 'discount_4', 'discount_5'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = GMVDiscount::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'discount_1' => $this->discount_1,
            'discount_2' => $this->discount_2,
            'discount_3' => $this->discount_3,
            'discount_4' => $this->discount_4,
            'discount_5' => $this->discount_5,
        ]);

        $query->andFilterWhere(['like', 'customer_cod', $this->customer_cod])
            ->andFilterWhere(['like', 'family', $this->family]);

        return $dataProvider;
    }
}
