<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model bitcream\gmvricambi\custom\common\models\CustomerUser */

$this->title = $model->name;
$this->params['breadcrumbs'][] = ['label' => 'Customer Users', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="customer-user-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Delete', ['delete', 'id' => $model->id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>
    <?=
        $model->customer->name;
    ?>
    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'id',
            'username',
            'name',
            'surname',
            'phone',
            'access_token',
            'auth_key',
            'password_hash',
            'password_reset_token',
            'password_reset_expires',
            'date_subscription',
            'email:email',
            'status',
            'created_at',
            'created_user_id',
            'updated_at',
            'updated_user_id',
            'verification_token',
            'activation_key',
        ],
    ]) ?>
</div>
