<?php

namespace bitcream\gmvricambi\custom\common\models;

use Yii;
use emberware\evidia\useroptions\common\models\UserOption;
/**
 * This is the model class for table "{{%user}}".
 * @property GMVCustomer $customer
 * @property Order $activeOrder
 * @property String $customerCod
 */
class CustomerUser extends \emberware\evidia\users\common\models\User
{

    /**
     * Gets query for [[Customer]].
     *
     * @return GMVCustomer
     */
    public function getCustomer()
    {
        // return $this->hasMany(Store::className(), ['store_manager_id' => 'id'])->inverseOf('storeManager');
        $customer_cod = $this->customerCod;

        return  GMVCustomer::find()->where(['customer_cod' => $customer_cod])->one();
    }

    public function getCustomerCod(){
        return UserOption::getUserOption("customer_cod", $this);
    }

    public function setCustomerCod(String $customerCod){
        UserOption::setUserOptionNewUser("customer_cod", $customerCod, $this);
        return true;
    }
    /**
     * Set for [[Customer]].
     *
     * @return boolean
     */
    public function setCustomer(GMVCustomer $customer)
    {
       $this->setCustomerCod($customer->customer_cod);
        // UserOption::setUserOptionNewUser("customer_cod", , $this);
        return true;
    }

    /**
     * Gets query for [[ActiveOrder]].
     *
     * @return Order
     */
    public function getActiveOrder()
    {
        $active_order = UserOption::getUserOption("active_order_id", $this);

        return  Order::find()->where(['id' => $active_order])->one();    }

    /**
     * Set for [[ActiveOrder]].
     *
     * @return bool
     */
    public function setActiveOrder(Order $order)
    {
        UserOption::setUserOptionNewUser("active_order_id", $order->id, $this);
        return true;

    }




}
