<?php

namespace bitcream\gmvricambi\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%order}}".
 *
 * @property int $id
 * @property string|null $name
 * @property string|null $slug
 * @property string|null $order_date
 * @property string|null $address
 * @property string|null $locality
 * @property int|null $postal_code
 * @property string|null $country
 * @property int|null $default_address
 * @property string|null $delivery_date
 * @property string|null $payment_method
 * @property string|null $payment_information
 * @property float|null $total
 * @property string|null $order_status
 * @property int|null $status
 * @property string|null $created_at
 * @property int|null $created_user_id
 * @property string|null $updated_at
 * @property int|null $updated_user_id
 * @property string|null $customer_cod
 * @property string|null $GMV_PK
 * @property string|null $GMV_PK_Insert_Date
 *
 * @property GMVCustomer $customerCod
 * @property GMVOrder $gMVPK
 * @property OrderItem[] $orderItems
 */
class Order extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%order}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['postal_code', 'default_address', 'status', 'created_user_id', 'updated_user_id'], 'integer'],
            [['total'], 'number'],
            [['name', 'slug', 'order_date', 'address', 'locality', 'country', 'delivery_date', 'payment_method', 'payment_information', 'order_status', 'created_at', 'updated_at', 'GMV_PK_Insert_Date'], 'string', 'max' => 255],
            [['customer_cod'], 'string', 'max' => 6],
            [['GMV_PK'], 'string', 'max' => 10],
            [['customer_cod'], 'exist', 'skipOnError' => true, 'targetClass' => GMVCustomer::className(), 'targetAttribute' => ['customer_cod' => 'customer_cod']],
            [['GMV_PK'], 'exist', 'skipOnError' => true, 'targetClass' => GMVOrder::className(), 'targetAttribute' => ['GMV_PK' => 'plant_cod']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'name' => Yii::t('app', 'Name'),
            'slug' => Yii::t('app', 'Slug'),
            'order_date' => Yii::t('app', 'Order Date'),
            'address' => Yii::t('app', 'Address'),
            'locality' => Yii::t('app', 'Locality'),
            'postal_code' => Yii::t('app', 'Postal Code'),
            'country' => Yii::t('app', 'Country'),
            'default_address' => Yii::t('app', 'Default Address'),
            'delivery_date' => Yii::t('app', 'Delivery Date'),
            'payment_method' => Yii::t('app', 'Payment Method'),
            'payment_information' => Yii::t('app', 'Payment Information'),
            'total' => Yii::t('app', 'Total'),
            'order_status' => Yii::t('app', 'Order Status'),
            'status' => Yii::t('app', 'Status'),
            'created_at' => Yii::t('app', 'Created At'),
            'created_user_id' => Yii::t('app', 'Created User ID'),
            'updated_at' => Yii::t('app', 'Updated At'),
            'updated_user_id' => Yii::t('app', 'Updated User ID'),
            'customer_cod' => Yii::t('app', 'Customer Cod'),
            'GMV_PK' => Yii::t('app', 'Gmv Pk'),
            'GMV_PK_Insert_Date' => Yii::t('app', 'Gmv Pk Insert Date'),
        ];
    }

    /**
     * Gets query for [[CustomerCod]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCustomerCod()
    {
        return $this->hasOne(GMVCustomer::className(), ['customer_cod' => 'customer_cod']);
    }

    /**
     * Gets query for [[GMVPK]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getGMVPK()
    {
        return $this->hasOne(GMVOrder::className(), ['plant_cod' => 'GMV_PK']);
    }

    /**
     * Gets query for [[OrderItems]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getOrderItems()
    {
        return $this->hasMany(OrderItem::className(), ['order_id' => 'id']);
    }
}
