<?php

namespace bitcream\gmvricambi\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%product}}".
 *
 * @property int $id
 * @property string|null $name
 * @property string|null $slug
 * @property string|null $description
 * @property string|null $detail
 * @property string|null $cover_image
 * @property float|null $cost
 * @property float|null $weight
 * @property string|null $size
 * @property int|null $status
 * @property string|null $created_at
 * @property int|null $created_user_id
 * @property string|null $updated_at
 * @property int|null $updated_user_id
 * @property string|null $article_cod
 * @property int|null $category_id
 *
 * @property OrderItem[] $orderItems
 * @property GMVArticle $articleCod
 * @property Category $category
 */
class Product extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%product}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['description', 'detail', 'cover_image'], 'string'],
            [['cost', 'weight'], 'number'],
            [['status', 'created_user_id', 'updated_user_id', 'category_id'], 'integer'],
            [['name', 'slug', 'size', 'created_at', 'updated_at', 'article_cod'], 'string', 'max' => 255],
            [['article_cod'], 'exist', 'skipOnError' => true, 'targetClass' => GMVArticle::className(), 'targetAttribute' => ['article_cod' => 'article_cod']],
            [['category_id'], 'exist', 'skipOnError' => true, 'targetClass' => Category::className(), 'targetAttribute' => ['category_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('gmv', 'ID'),
            'name' => Yii::t('gmv', 'Name'),
            'slug' => Yii::t('gmv', 'Slug'),
            'description' => Yii::t('gmv', 'Description'),
            'detail' => Yii::t('gmv', 'Detail'),
            'cover_image' => Yii::t('gmv', 'Cover Image'),
            'cost' => Yii::t('gmv', 'Cost'),
            'weight' => Yii::t('gmv', 'Weight'),
            'size' => Yii::t('gmv', 'Size'),
            'status' => Yii::t('gmv', 'Status'),
            'created_at' => Yii::t('gmv', 'Created At'),
            'created_user_id' => Yii::t('gmv', 'Created User ID'),
            'updated_at' => Yii::t('gmv', 'Updated At'),
            'updated_user_id' => Yii::t('gmv', 'Updated User ID'),
            'article_cod' => Yii::t('gmv', 'Article Cod'),
            'category_id' => Yii::t('gmv', 'Category ID'),
        ];
    }

    /**
     * Gets query for [[OrderItems]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getOrderItems()
    {
        return $this->hasMany(OrderItem::className(), ['product_id' => 'id'])->inverseOf('product');
    }

    /**
     * Gets query for [[ArticleCod]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getArticleCod()
    {
        return $this->hasOne(GMVArticle::className(), ['article_cod' => 'article_cod'])->inverseOf('products');
    }

    /**
     * Gets query for [[Category]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCategory()
    {
        return $this->hasOne(Category::className(), ['id' => 'category_id'])->inverseOf('products');
    }
}
