<?php

namespace bitcream\gmvricambi\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%order}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%GMV_order}}`
 */
class M210820124238AddOrderCodColumnToOrderTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%order}}', 'order_cod', $this->string()->null());

        // creates index for column `order_cod`
        $this->createIndex(
            '{{%idx-order-order_cod}}',
            '{{%order}}',
            'order_cod'
        );

        // add foreign key for table `{{%GMV_order}}`
        $this->addForeignKey(
            '{{%fk-order-order_cod}}',
            '{{%order}}',
            'order_cod',
            '{{%GMV_order}}',
            'plant_cod',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%GMV_order}}`
        $this->dropForeignKey(
            '{{%fk-order-order_cod}}',
            '{{%order}}'
        );

        // drops index for column `order_cod`
        $this->dropIndex(
            '{{%idx-order-order_cod}}',
            '{{%order}}'
        );

        $this->dropColumn('{{%order}}', 'order_cod');
    }
}
