<?php

namespace bitcream\gmvricambi\custom\api\models;

use Yii;
/**
 * This is the model class for table "{{%order}}".
 *
 */
class Order extends \bitcream\gmvricambi\custom\common\models\Order
{
    public function fields(){
        return [
            'id',
            'name',
            'slug',
            'order_date',
            'address',
            'locality',
            'postal_code',
            'country',
            'default_address',
            'delivery_date',
            'payment_method',
            'payment_information',
            'total',
            'order_status',
            'status',
            'customer' => 'customerCod',
            //'gmv_order' => 'orderCod',
            'order_items' => 'orderItems',
        ];
    }

     /**
     * Gets query for [[CustomerCod]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCustomerCod()
    {
        return $this->hasOne(GMVCustomer::className(), ['customer_cod' => 'customer_cod'])->inverseOf('orders');
    }

    /**
     * Gets query for [[OrderCod]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getOrderCod()
    {
        return $this->hasOne(GMVOrder::className(), ['plant_cod' => 'order_cod'])->inverseOf('orders');
    }

    /**
     * Gets query for [[OrderItems]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getOrderItems()
    {
        return $this->hasMany(OrderItem::className(), ['order_id' => 'id'])->inverseOf('order');
    }

}
