<?php

namespace bitcream\gmvricambi\custom\backend\controllers;

use Yii;
use bitcream\gmvricambi\custom\common\models\CustomerUser;
use bitcream\gmvricambi\custom\backend\models\CustomerUserSearch;
use bitcream\gmvricambi\custom\common\models\GMVCustomer;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * CustomerUserController implements the CRUD actions for CustomerUser model.
 */
class CustomerUserController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all CustomerUser models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new CustomerUserSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single CustomerUser model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new CustomerUser model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new CustomerUser();
        // $user = new User();

        if ($model->load(Yii::$app->request->post())) {
            $data = Yii::$app->request->post();
            $customerUser = $data['CustomerUser'];
            error_log(json_encode($data));

            $model->username = $customerUser['username'];
            $model->name = $customerUser['name'];
            $model->surname = $customerUser['surname'];
            $model->email = $customerUser['email'];
            $model->password_hash = Yii::$app->security->generatePasswordHash(rand(1000,9999));
            $model->auth_key = $model->generateAuthKey();
            $model->created_user_id = Yii::$app->user->id;
            $model->updated_user_id = Yii::$app->user->id;
            $model->created_at = time();
            $model->updated_at = time();
            // $model->login();
            $model->save();
            //aggiunta permesso
            // $auth = \Yii::$app->authManager;
            // $customerUserRole = $auth->getRole('');
            // $auth->assign($exhibitorRole, $user->id);
            // $model->setCustomerCod($customerUser['customerCod']);
            $model->customerCod = $customerUser['customerCod'];
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('create', [
            'model' => $model,
            'customers' => GMVCustomer::find()->all(),
        ]);
    }

    /**
     * Updates an existing CustomerUser model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing CustomerUser model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the CustomerUser model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return CustomerUser the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = CustomerUser::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
