<?php

namespace bitcream\gmvricambi\custom\backend\controllers;

use Yii;
use bitcream\gmvricambi\custom\backend\models\Order;
use bitcream\gmvricambi\custom\backend\models\OrderSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use bitcream\gmvricambi\custom\common\models\CustomerUser;
use bitcream\gmvricambi\custom\common\models\GMVOrder;

/**
 * OrderController implements the CRUD actions for Order model.
 */
class OrderController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            // 'access' => [
            //     'class' => AccessControl::className(),
            //     'rules' => [
            //         [
            //             'actions' => ['login', 'error'],
            //             'allow' => true,
            //         ],
            //         [
            //             'actions' => ['update', 'delete', 'view'],
            //             'allow' => true,
            //             'roles' => ['ViewOwnContent'],
            //             'roleParams' => function() {
            //                 return ['content' => Order::findOne(['id' => Yii::$app->request->get('id')])];
            //             },
            //         ],
            //         [
            //             'actions' => ['create', 'index','contacts-update', 'documents-update','csv-view', 'welcome-page-update', 'disabled', 'enabled'],
            //             'allow' => true,
            //             'roles' => ['@'],
            //         ],
            //     ],
            // ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Order models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new OrderSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Order model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Order model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Order();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Order model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Order model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Order model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Order the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Order::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('gmv', 'The requested page does not exist.'));
    }

    /**
     * Lists all Order models.
     * @return mixed
     */
    public function actionIndexMy()
    {
        $searchModel = new OrderSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        // Yii::$app->user->id;
        $customerUser = CustomerUser::findOne(Yii::$app->user->id);
        $order = Order::findOne(['customer_cod' => $customerUser->customerCod]);
        return $this->render('index_my', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Order model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionViewMy($id)
    {
        $customerUser = CustomerUser::findOne(Yii::$app->user->id);
        $order = Order::findOne(['customer_cod' => $customerUser->customerCod]);
        return $this->render('view_my', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Order model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreateMy()
    {
        $model = new Order();
        $customerUser = CustomerUser::findOne(Yii::$app->user->id);
        $order = Order::findOne(['customer_cod' => $customerUser->customerCod]);
        if ($model->load(Yii::$app->request->post())) {
            $model->customer_cod = $customerUser->customerCod;
            $model->save();
            return $this->redirect(['index-my']);

        }

        return $this->render('create_my', [
            'model' => $model,
            'order' => GMVOrder::find()->all(),
        ]);
    }

    /**
     * Updates an existing Order model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdateMy($id)
    {
        $model = $this->findModel($id);
        $customerUser = CustomerUser::findOne(Yii::$app->user->id);
        $order = Order::findOne(['customer_cod' => $customerUser->customerCod]);
        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['index-my']);
        }

        return $this->render('update_my', [
            'model' => $model,
            'order' => GMVOrder::find()->all(),
        ]);
    }

    /**
     * Deletes an existing Order model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDeleteMy($id)
    {
        $this->findModel($id)->delete();
        // $customerUser = CustomerUser::findOne(Yii::$app->user->id);
        // $order = Order::findOne(['customer_cod' => $customerUser->customerCod]);
        return $this->redirect(['index_my']);
    }
}
