<?php

namespace bitcream\gmvricambi\custom\backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use bitcream\gmvricambi\custom\backend\models\GMVList;

/**
 * GMVListSearch represents the model behind the search form of `bitcream\gmvricambi\custom\backend\models\GMVList`.
 */
class GMVListSearch extends GMVList
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['price_list_cod', 'customer_cod', 'article_cod', 'currency'], 'safe'],
            [['quantity', 'price', 'price_1', 'price_2', 'price_3', 'price_4', 'price_5'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = GMVList::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'quantity' => $this->quantity,
            'price' => $this->price,
            'price_1' => $this->price_1,
            'price_2' => $this->price_2,
            'price_3' => $this->price_3,
            'price_4' => $this->price_4,
            'price_5' => $this->price_5,
        ]);

        $query->andFilterWhere(['like', 'price_list_cod', $this->price_list_cod])
            ->andFilterWhere(['like', 'customer_cod', $this->customer_cod])
            ->andFilterWhere(['like', 'article_cod', $this->article_cod])
            ->andFilterWhere(['like', 'currency', $this->currency]);

        return $dataProvider;
    }
}
