<?php

namespace bitcream\gmvricambi\custom\backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use bitcream\gmvricambi\custom\backend\models\GMVShippingAddress;

/**
 * GMVShippingAddressSearch represents the model behind the search form of `bitcream\gmvricambi\custom\backend\models\GMVShippingAddress`.
 */
class GMVShippingAddressSearch extends GMVShippingAddress
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['customer_cod', 'shipping_address_cod', 'datetime', 'business_name_address', 'address', 'locality', 'province'], 'safe'],
            [['postal_code'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = GMVShippingAddress::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'datetime' => $this->datetime,
            'postal_code' => $this->postal_code,
        ]);

        $query->andFilterWhere(['like', 'customer_cod', $this->customer_cod])
            ->andFilterWhere(['like', 'shipping_address_cod', $this->shipping_address_cod])
            ->andFilterWhere(['like', 'business_name_address', $this->business_name_address])
            ->andFilterWhere(['like', 'address', $this->address])
            ->andFilterWhere(['like', 'locality', $this->locality])
            ->andFilterWhere(['like', 'province', $this->province]);

        return $dataProvider;
    }
}
