<?php

namespace bitcream\gmvricambi\custom\backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use bitcream\gmvricambi\custom\backend\models\OrderItem;

/**
 * OrderItemSearch represents the model behind the search form of `bitcream\gmvricambi\custom\backend\models\OrderItem`.
 */
class OrderItemSearch extends OrderItem
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'quantity', 'status', 'created_user_id', 'updated_user_id', 'product_id', 'order_id'], 'integer'],
            [['name', 'slug', 'plant_code', 'orderitem_status', 'created_at', 'updated_at', 'total_price', 'gross_price', 'family'], 'safe'],
            [['product_price', 'discount_1', 'discount_2', 'discount_3', 'discount_4', 'discount_5'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = OrderItem::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'product_price' => $this->product_price,
            'quantity' => $this->quantity,
            'status' => $this->status,
            'created_user_id' => $this->created_user_id,
            'updated_user_id' => $this->updated_user_id,
            'product_id' => $this->product_id,
            'order_id' => $this->order_id,
            'discount_1' => $this->discount_1,
            'discount_2' => $this->discount_2,
            'discount_3' => $this->discount_3,
            'discount_4' => $this->discount_4,
            'discount_5' => $this->discount_5,
        ]);

        $query->andFilterWhere(['like', 'name', $this->name])
            ->andFilterWhere(['like', 'slug', $this->slug])
            ->andFilterWhere(['like', 'plant_code', $this->plant_code])
            ->andFilterWhere(['like', 'orderitem_status', $this->orderitem_status])
            ->andFilterWhere(['like', 'created_at', $this->created_at])
            ->andFilterWhere(['like', 'updated_at', $this->updated_at])
            ->andFilterWhere(['like', 'total_price', $this->total_price])
            ->andFilterWhere(['like', 'gross_price', $this->gross_price])
            ->andFilterWhere(['like', 'family', $this->family]);

        return $dataProvider;
    }
}
