<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use dosamigos\ckeditor\CKEditor;

/* @var $this yii\web\View */
/* @var $model bitcream\gmvricambi\custom\backend\models\Category */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="category-form">

    <?php $form = ActiveForm::begin(); ?>
 
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'languages')->widget(bitcream\gmvricambi\custom\common\widget\LanguageFlagWidget::class,[
                'languages' => $model->languages,
            ])->label(Yii::t('gmv', 'Language'));
            ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <?= $form->field($model, 'name')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6">
            <?= $form->field($model, 'slug')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <?= $form->field($model, 'description')->widget(CKEditor::className(), [
                        'options' => ['rows' => 3],
                        'preset' => 'custom',
                        'clientOptions' => [
                            'height' => 200,
                            'toolbarGroups' => [
                                ['name' => 'basicstyles', 'groups' => ['basicstyles', 'cleanup']],
                                ['name' => 'links', 'groups' => ['links']],
                            ],
                            'removeButtons' => 'Subscript,Superscript,Flash,Table,HorizontalRule,Smiley,SpecialChar,PageBreak,Iframe,Anchor,Strike',
                            'removePlugins' => 'elementspath',
                            'resize_enabled' => false
                        ]
            ]) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <?=$form->field($model, 'image')->widget(floor12\files\components\FileInputWidget::class) ?>
            <input type="hidden" name="cover_image" value="<?=($cover_image)? $cover_image->href: ""?>">
        </div>
    </div>
    
    <div class="form-group">
        <?= Html::submitButton(Yii::t('gmv', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
