<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model bitcream\gmvricambi\custom\backend\models\OrderItem */

$this->title = $model->name;
$this->params['breadcrumbs'][] = ['label' => Yii::t('gmv', 'Order Items'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="order-item-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a(Yii::t('gmv', 'Update'), ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a(Yii::t('gmv', 'Delete'), ['delete', 'id' => $model->id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => Yii::t('gmv', 'Are you sure you want to delete this item?'),
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'id',
            'name',
            'slug',
            'plant_code',
            'product_price',
            'quantity',
            'orderitem_status',
            'status',
            'created_at',
            'created_user_id',
            'updated_at',
            'updated_user_id',
            'product_id',
            'order_id',
            'total_price',
            'gross_price',
            'family',
            'discount_1',
            'discount_2',
            'discount_3',
            'discount_4',
            'discount_5',
        ],
    ]) ?>

</div>
