<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model bitcream\gmvricambi\custom\backend\models\Order */

$this->title = $model->name;
$this->params['breadcrumbs'][] = ['label' => Yii::t('gmv', 'Orders'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="order-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a(Yii::t('gmv', 'Update'), ['update-my', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a(Yii::t('gmv', 'Delete'), ['delete-my', 'id' => $model->id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => Yii::t('gmv', 'Are you sure you want to delete this item?'),
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'id',
            'name',
            'slug',
            'order_date',
            'address',
            'locality',
            'postal_code',
            'country',
            'default_address',
            'delivery_date',
            'payment_method',
            'payment_information',
            'total',
            'order_status',
            'status',
            'created_at',
            'created_user_id',
            'updated_at',
            'updated_user_id',
            'customer_cod',
            'GMV_PK',
            'GMV_PK_Insert_Date'
        ],
    ]) ?>

</div>
