<?php

namespace bitcream\gmvricambi\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%order_item}}".
 *
 * @property int $id
 * @property string|null $name
 * @property string|null $slug
 * @property string|null $plant_code
 * @property float|null $product_price
 * @property int|null $quantity
 * @property string|null $orderitem_status
 * @property int|null $status
 * @property string|null $created_at
 * @property int|null $created_user_id
 * @property string|null $updated_at
 * @property int|null $updated_user_id
 * @property int|null $product_id
 * @property int|null $order_id
 * @property string|null $total_price
 * @property string|null $gross_price
 * @property string|null $family
 * @property float|null $discount_1
 * @property float|null $discount_2
 * @property float|null $discount_3
 * @property float|null $discount_4
 * @property float|null $discount_5
 *
 * @property Order $order
 * @property Product $product
 */
class OrderItem extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%order_item}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['product_price', 'discount_1', 'discount_2', 'discount_3', 'discount_4', 'discount_5'], 'number'],
            [['quantity', 'status', 'created_user_id', 'updated_user_id', 'product_id', 'order_id'], 'integer'],
            [['name', 'slug', 'plant_code', 'orderitem_status', 'created_at', 'updated_at', 'total_price', 'gross_price'], 'string', 'max' => 255],
            [['family'], 'string', 'max' => 3],
            [['order_id'], 'exist', 'skipOnError' => true, 'targetClass' => Order::className(), 'targetAttribute' => ['order_id' => 'id']],
            [['product_id'], 'exist', 'skipOnError' => true, 'targetClass' => Product::className(), 'targetAttribute' => ['product_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('gmv', 'ID'),
            'name' => Yii::t('gmv', 'Name'),
            'slug' => Yii::t('gmv', 'Slug'),
            'plant_code' => Yii::t('gmv', 'Plant Code'),
            'product_price' => Yii::t('gmv', 'Product Price'),
            'quantity' => Yii::t('gmv', 'Quantity'),
            'orderitem_status' => Yii::t('gmv', 'Orderitem Status'),
            'status' => Yii::t('gmv', 'Status'),
            'created_at' => Yii::t('gmv', 'Created At'),
            'created_user_id' => Yii::t('gmv', 'Created User ID'),
            'updated_at' => Yii::t('gmv', 'Updated At'),
            'updated_user_id' => Yii::t('gmv', 'Updated User ID'),
            'product_id' => Yii::t('gmv', 'Product ID'),
            'order_id' => Yii::t('gmv', 'Order ID'),
            'total_price' => Yii::t('gmv', 'Total Price'),
            'gross_price' => Yii::t('gmv', 'Gross Price'),
            'family' => Yii::t('gmv', 'Family'),
            'discount_1' => Yii::t('gmv', 'Discount 1'),
            'discount_2' => Yii::t('gmv', 'Discount 2'),
            'discount_3' => Yii::t('gmv', 'Discount 3'),
            'discount_4' => Yii::t('gmv', 'Discount 4'),
            'discount_5' => Yii::t('gmv', 'Discount 5'),
        ];
    }

    /**
     * Gets query for [[Order]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getOrder()
    {
        return $this->hasOne(Order::className(), ['id' => 'order_id']);
    }

    /**
     * Gets query for [[Product]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getProduct()
    {
        return $this->hasOne(Product::className(), ['id' => 'product_id']);
    }
}
