<?php

namespace bitcream\gmvricambi\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%order}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%GMV_customer}}`
 */
class M210820124032AddCustomerCodColumnToOrderTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%order}}', 'customer_cod', $this->string()->null());

        // creates index for column `customer_cod`
        $this->createIndex(
            '{{%idx-order-customer_cod}}',
            '{{%order}}',
            'customer_cod'
        );

        // add foreign key for table `{{%GMV_customer}}`
        $this->addForeignKey(
            '{{%fk-order-customer_cod}}',
            '{{%order}}',
            'customer_cod',
            '{{%GMV_customer}}',
            'customer_cod',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%GMV_customer}}`
        $this->dropForeignKey(
            '{{%fk-order-customer_cod}}',
            '{{%order}}'
        );

        // drops index for column `customer_cod`
        $this->dropIndex(
            '{{%idx-order-customer_cod}}',
            '{{%order}}'
        );

        $this->dropColumn('{{%order}}', 'customer_cod');
    }
}
