<?php

namespace bitcream\gmvricambi\custom\api\models;

use Yii;
use bitcream\gmvricambi\custom\common\models\ProductImage;
/**
 * This is the model class for table "{{%gmv-customer}}".
 *
 */
class GMVArticle extends \bitcream\gmvricambi\custom\common\models\GMVArticle
{
    public function fields(){
        return [
            'article_cod',
            //'description',
            //'family',
            'unit_of_measure_cod',
            'unit_of_measure',
            'weight',
            //'packaging_code',
            "cover_image" => "coverImage",
            'article_description' => 'product'
        ];
    }

    // /**
    //  * Gets query for [[Product]].
    //  *
    //  * @return \yii\db\ActiveQuery
    //  */
    // public function getProducts()
    // {
    //     return $this->hasMany(Product::className(), ['article_cod' => 'article_cod']);
    // }

    /**
     * Gets query for [[Product]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getProduct()
    {
        //return Product::findOne($this->article_cod);
        return Product::find()->where(
            [
                'article_cod' => $this->article_cod,
                'status' => 30,
            ]);
        //return $this->hasOne(Product::className(), ['article_cod' => 'article_cod']);
    }


    public function getCoverImage(){
        return ProductImage::find()->where(['article_cod' => $this->article_cod])->one();
    }

}
