<?php

namespace bitcream\gmvricambi\custom\api\models;

use Yii;
/**
 * This is the model class for table "{{%gmv-order}}".
 *
 */
class GMVOrder extends \bitcream\gmvricambi\custom\common\models\GMVOrder
{
    public function fields(){
        return [
            'plant_cod',
            'order_reference',
            'plant_reference',
            'plant_type',
            'order_confirmation_date',
            'offer_number',
            'Protocollo',
        ];
    }

    /**
     * Gets query for [[Orders]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getOrders()
    {
        return $this->hasMany(Order::className(), ['plant_cod' => 'plant_cod'])->inverseOf('GMVOrder');
    }

}
