<?php

namespace bitcream\gmvricambi\custom\api\models;

use Yii;
use bitcream\gmvricambi\custom\common\models\CustomerUser;
/**
 * This is the model class for table "{{%order}}".
 *
 */
class Order extends \bitcream\gmvricambi\custom\common\models\Order
{
    public function fields(){
        return [
            'id',
            'name',
            'slug',
            'order_date',
            'address',
            'locality',
            'postal_code',
            'province' => 'provinceCod',
            'country' => 'countryCod',
            'shipping_address' => 'shippingAddress',
            'delivery_date',
            'payment_method',
            'payment_information',
            'total',
            'order_status',
            'status',
            'order_reference',
            'plant_reference',
            'GMV_PK_Insert_Date',
            'GMV_PK',
            'customer' => 'customerCod',            
            'items' => 'orderItems',      
        ];
    }

     /**
     * Gets query for [[CustomerCod]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCustomerCod()
    {
        return $this->hasOne(GMVCustomer::className(), ['customer_cod' => 'customer_cod'])->inverseOf('orders');
    }

    /**
     * Gets query for [[OrderCod]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getOrderCod()
    {
        return $this->hasOne(GMVOrder::className(), ['plant_cod' => 'order_cod'])->inverseOf('orders');
    }

    /**
     * Gets query for [[OrderItems]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getOrderItems()
    {
        return OrderItem::find()->where(['status' => '30', 'order_id' => $this->id])->all();
    }

    /**
     * Gets query for [[OrderItems]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getShippingAddress()
    {
        $customerUser = CustomerUser::findOne(Yii::$app->user->id);
        return GMVShippingAddress::find()->where(['customer_cod' => $customerUser->customerCod, 'shipping_address_cod' => $this->shipping_address]);
    }

    /**
     * Gets query for [[province_cod]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getProvinceCod()
    {
        return $this->hasOne(GMVProvince::className(), ['province_cod' => 'province']);
    }

    /**
     * Gets query for [[GMVCountry]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCountryCod()
    {
        return $this->hasOne(GMVCountry::className(), ['country_cod' => 'country']);
    }

    /**
     * Gets query for [[ActiveOrder]].
     *
     * @return Order
     */
    public function getActiveOrder()
    {
        $active_order = UserOption::getUserOption("active_order_id", $this);

        return  Order::find()->where(['id' => $active_order])->one();   
    }

    
}
