<?php

namespace bitcream\gmvricambi\custom\api\models;

use Yii;
/**
 * This is the model class for table "{{%gmv-customer}}".
 *
 */
class OrderItem extends \bitcream\gmvricambi\custom\common\models\OrderItem
{
    public function fields(){
        return [
            'id',
            // 'name',
            // 'slug',
            'plant_code',
            'product_price',
            'quantity',
            'orderitem_status',
            'article' => 'article',
        ];
    }

    /**
     * Gets query for [[Product]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getArticle()
    {
        return $this->hasOne(GMVArticle::className(), ['article_cod' => 'article_cod']);
    }

}
