<?php

namespace bitcream\gmvricambi\custom\backend\controllers;

use Yii;
use bitcream\gmvricambi\custom\backend\models\GMVList;
use bitcream\gmvricambi\custom\backend\models\GMVListSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * GmvListController implements the CRUD actions for GMVList model.
 */
class GmvListController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all GMVList models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new GMVListSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single GMVList model.
     * @param string $price_list_cod
     * @param string $customer_cod
     * @param string $article_cod
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($price_list_cod, $customer_cod, $article_cod)
    {
        return $this->render('view', [
            'model' => $this->findModel($price_list_cod, $customer_cod, $article_cod),
        ]);
    }

    /**
     * Creates a new GMVList model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new GMVList();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'price_list_cod' => $model->price_list_cod, 'customer_cod' => $model->customer_cod, 'article_cod' => $model->article_cod]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing GMVList model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param string $price_list_cod
     * @param string $customer_cod
     * @param string $article_cod
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($price_list_cod, $customer_cod, $article_cod)
    {
        $model = $this->findModel($price_list_cod, $customer_cod, $article_cod);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'price_list_cod' => $model->price_list_cod, 'customer_cod' => $model->customer_cod, 'article_cod' => $model->article_cod]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing GMVList model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param string $price_list_cod
     * @param string $customer_cod
     * @param string $article_cod
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($price_list_cod, $customer_cod, $article_cod)
    {
        $this->findModel($price_list_cod, $customer_cod, $article_cod)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the GMVList model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param string $price_list_cod
     * @param string $customer_cod
     * @param string $article_cod
     * @return GMVList the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($price_list_cod, $customer_cod, $article_cod)
    {
        if (($model = GMVList::findOne(['price_list_cod' => $price_list_cod, 'customer_cod' => $customer_cod, 'article_cod' => $article_cod])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('gmv', 'The requested page does not exist.'));
    }
}
