<?php

namespace bitcream\gmvricambi\custom\backend\controllers;

use Yii;
use bitcream\gmvricambi\custom\backend\models\Order;
use bitcream\gmvricambi\custom\backend\models\OrderCustomerSearch;
use bitcream\gmvricambi\custom\backend\models\OrderItemSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use bitcream\gmvricambi\custom\common\models\GMVOrder;
use bitcream\gmvricambi\custom\common\models\CustomerUser;

/**
 * OrderController implements the CRUD actions for Order model.
 */
class OrderStatusController extends Controller
{
    /**
     * Function for show order in processing
     */
    public function actionProcessing(){
        $params['order_status'] = 'processing';
        $searchModel = new OrderCustomerSearch();
        $dataProvider = $searchModel->search($params);

        return $this->render('index-processing', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Function for show order deleted
     */
    public function actionDeleted(){
        $params['order_status'] = 'deleted';
        $searchModel = new OrderCustomerSearch();
        $dataProvider = $searchModel->search($params);

        return $this->render('index-deleted', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Function for show order sent to GMV
     */
    public function actionSentGmv(){
        $params['order_status'] = 'sent';
        $searchModel = new OrderCustomerSearch();
        $dataProvider = $searchModel->search($params);

        return $this->render('index-sent-gmv', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Function for show order confirm to GMV
     */
    public function actionConfirmedGmv(){
        $params['order_status'] = 'confirmed';
        $searchModel = new OrderCustomerSearch();
        $dataProvider = $searchModel->search($params);

        return $this->render('index-confirmed-gmv', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Finds the Order model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Order the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Order::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('gmv', 'The requested page does not exist.'));
    }
}
?>