<?php

namespace bitcream\gmvricambi\custom\backend\controllers;

use Yii;
use bitcream\gmvricambi\custom\backend\models\Product;
use bitcream\gmvricambi\custom\backend\models\ProductSearch;
use bitcream\gmvricambi\custom\backend\models\GMVArticle;
use bitcream\gmvricambi\custom\backend\models\OrderItem;
use bitcream\gmvricambi\custom\common\models\CustomerUser;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * ProductController implements the CRUD actions for Product model.
 */
class ProductController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Product models.
     * @return mixed
     */
    public function actionIndex()
    {
        $model = new Product();
        $searchModel = new ProductSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'model' => $model
        ]);
    }

    /**
     * Displays a single Product model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
            
        ]);
    }

    /**
     * Creates a new Product model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate($article)
    {
        $gmvArticle = GMVArticle::findOne($article);
        $model = new Product();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {

            $languages_to_set = isset(Yii::$app->request->post()['language_check']) ? Yii::$app->request->post()['language_check'] :[];
            $model->setLanguages($languages_to_set);

            return $this->redirect(['gmv-article/index']);
        }

        return $this->render('create', [
            'model' => $model,
            'gmvArticle' => $gmvArticle
        ]);
    }

    /**
     * Updates an existing Product model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id, $article)
    {
        $gmvArticle = GMVArticle::findOne($article);
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {

            $languages_to_set = isset(Yii::$app->request->post()['language_check']) ? Yii::$app->request->post()['language_check'] :[];
            $model->setLanguages($languages_to_set);

            return $this->redirect(['gmv-article/index']);
        }

        return $this->render('update', [
            'model' => $model,
            'gmvArticle' => $gmvArticle
        ]);
    }


    /**
     * Deletes an existing Product model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id, $controller)
    {
        $product = $this->findModel($id);
        $language = $product->getLanguageObject();
        $test = $product->setLanguage($language, 0);
        
        $this->findModel($id)->delete();

        return $this->redirect(['gmv-article/index']);
    }

    /**
     * Finds the Product model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Product the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Product::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('gmv', 'The requested page does not exist.'));
    }


    /**
     * Displays a single Product model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionViewMy($id)
    {
        $orderItem = new OrderItem();
        return $this->render('view_my', [
            'model' => $this->findModel($id),
            'orderItem' => $orderItem,
        ]);
    }

     /**
     * Lists all Product models.
     * @return mixed
     */
    public function actionIndexMy()
    {
        $model = new Product();
        $searchModel = new ProductSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index_my', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'model' => $model
        ]);
    }

    public function actionAddProductToOrder(){

        $orderItem = new OrderItem();
        $orderItem->addOrderItem(Yii::$app->request->post()['Product'], Yii::$app->request->post()['OrderItem']);        

        return $this->render('view_my', [
            'model' => $this->findModel(Yii::$app->request->post()['Product']['id']),
            'orderItem' => $orderItem,
        ]);
    }
}
