<?php

namespace bitcream\gmvricambi\custom\backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use bitcream\gmvricambi\custom\backend\models\GMVOrder;

/**
 * GMVOrderSearch represents the model behind the search form of `bitcream\gmvricambi\custom\backend\models\GMVOrder`.
 */
class GMVOrderSearch extends GMVOrder
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['plant_cod', 'order_reference', 'plant_reference', 'plant_type', 'order_confirmation_date', 'offer_ number'], 'safe'],
            [['Protocollo'], 'integer'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = GMVOrder::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if(!$params){
            $query->where('0=1');
            return $dataProvider; 
        }else{
            foreach($params as $key => $value){
                // grid filtering conditions
                $query->andFilterWhere([
                    $key => $value,
                ]);
            }
        }

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'order_confirmation_date' => $this->order_confirmation_date,
            'Protocollo' => $this->Protocollo,
        ]);

        $query->andFilterWhere(['like', 'plant_cod', $this->plant_cod])
            ->andFilterWhere(['like', 'order_reference', $this->order_reference])
            ->andFilterWhere(['like', 'plant_reference', $this->plant_reference])
            ->andFilterWhere(['like', 'plant_type', $this->plant_type])
            ->andFilterWhere(['like', 'offer_ number', $this->offer_number]);

        return $dataProvider;
    }
}
