<?php

namespace bitcream\gmvricambi\custom\backend\models;

use Yii;
use bitcream\gmvricambi\custom\common\behaviors\StatusBehaviors;
use bitcream\gmvricambi\custom\common\behaviors\CreateUpdateBehaviors;
use yii2tech\ar\softdelete\SoftDeleteBehavior;
use bitcream\gmvricambi\custom\common\models\CustomerUser;
use yii\behaviors\SluggableBehavior;

/**
 * This is the model class for table "{{%order_item}}".
 *
 */
class OrderItem extends \bitcream\gmvricambi\custom\common\models\OrderItem
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'softDeleteBehavior' => [
                'class' => SoftDeleteBehavior::className(),
                'softDeleteAttributeValues' => [
                    'status' => 0
                ],
                'replaceRegularDelete' => true // mutate native `delete()` method
            ],
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ],
            [
                'class' => SluggableBehavior::class,
                'attribute' => 'name',
                'slugAttribute' => 'slug',
            ],
        ]);
    }

    public function addOrderItem($productPost, $orderItemPost){

        $customerUser = CustomerUser::findOne(Yii::$app->user->id);
        $activeOrder = $customerUser->activeOrder;

        $product = Product::findOne($productPost['id']);
        $orderItem = new OrderItem();
        $orderItem->name = $product->name;
        $orderItem->slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $product->name)));
        $orderItem->plant_code = $orderItemPost['plant_code'];
        $orderItem->product_price = 0;
        $orderItem->quantity = $orderItemPost['quantity'];
        $orderItem->orderitem_status = 30;
        $orderItem->order_id = $activeOrder->id;
        $orderItem->total_price = 0 * $orderItemPost['quantity'];
        $orderItem->article_cod = $product->article_cod;
        $orderItem->save(false);

        return true;
    }
}
