<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use bitcream\gmvricambi\custom\common\widget\ImageMapsWidget;
/* @var $this yii\web\View */
/* @var $model bitcream\gmvricambi\custom\backend\models\GMVAssembledArticle */

$this->title = $model->article_cod;
$this->params['breadcrumbs'][] = ['label' => Yii::t('gmv', 'Gmv Assembled Articles'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="gmvassembled-article-view">

    <h1><?= Html::encode($this->title) ?></h1>
    <div class="row">
    <?php if($productImage){ ?>
        <div class="col-md-6 col-xs-12">
            <?=ImageMapsWidget::widget(['image' => $productImage->image, 'components' => $components]);?>
        </div>
        <div class="col-md-6 col-xs-12">
    <?php  }else{ ?>
        <div class="col-md-12 col-xs-12">
    <?php  } ?>

            <?= DetailView::widget([
                'model' => $model,
                'attributes' => [
                    'article_cod',
                    'description',
                    'family',
                    'unit_of_measure_cod',
                    'unit_of_measure',
                    'weight',
                    'packaging_code',
                    'assembled_product',
                ],
            ]) ?>
        </div>
    </div>
    <hr>
    <h3><?= Yii::t('gmv', 'Product component') ?></h3>
    <br>
    <p>
        <?= Html::a(Yii::t('gmv', 'Create Product component'), ['product-component/create', 'assembledArticle' => $model->article_cod], ['class' => 'btn btn-success']) ?>
    </p>

    <?= $this->render('_datatable-product-component',[
        'searchModel' => $searchModelProductComponent,
        'dataProvider' => $dataProviderProductComponent,
        'assembledArticle' => $model,
    ]) ?>


</div>
