<?php

use yii\widgets\Breadcrumbs;
use yii\helpers\Html;
use emberware\evidia\datatable\common\models\DataTableCustom;

?>
<div class="datatable">
        <?=
        DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            'id' => 'orderitem-table',
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => [
                'article_cod',
                'name',
                'quantity',
                'product_price',
                'plant_code',
                [
                    'format'=>'raw',
                    'label' => 'Azioni',
                    'value' => function ($model, $key, $index, $column) use ($order)
                    {
                        return Html::a("<i class='fa fa-trash-o'></i>", ['order-item/delete-custom', 'id'=> $model->id, 'order'=> $order->id],                    
                        [
                            'class' => 'btn btn-danger action-button',
                            'data' => [
                                'confirm' => Yii::t('gmv','Are you sure you want to delete this order item?'),
                                'method' => 'post',
                            ]
                        ]);
                    }
                ]
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('gmv',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
    ?>
</div>