<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\datecontrol\DateControl;
use yii\helpers\ArrayHelper;
use kartik\select2\Select2;
/* @var $this yii\web\View */
/* @var $model bitcream\gmvricambi\custom\backend\models\Order */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="order-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-md-6">
            <?= $form->field($model, 'name')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
        <?=$form->field($model, 'order_date')->widget(DateControl::classname(), [
                    'type' => 'date',
                    'ajaxConversion' => false,
                    'autoWidget' => true,
                    'widgetClass' => '',
                    'displayFormat' => 'php:d/m/Y',
                    'saveFormat' => 'php:U',
                    'saveTimezone' => 'Europe/Amsterdam',
                    'displayTimezone' => 'Europe/Amsterdam',
                    'widgetOptions' => [
                        'pluginOptions' => [
                            'autoclose' => true,
                            'format' => 'php:d/m/Y'
                        ]
                    ],
                    'language' => 'it'
                ]);
            ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <?= $form->field($model, 'address')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <?= $form->field($model, 'locality')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <?= $form->field($model, 'province')->widget(Select2::classname(), [
                'name' => 'province',
                'class' => 'form-group province_ids form-control',
                'value' => ArrayHelper::map($provinces, 'province_cod', function ($province) {
                    return $province['province_cod'];
                }),
                'id' => 'province',
                'data' => ArrayHelper::map($provinces, 'province_cod', function ($province) {
                    return $province['description'];
                }),
                'options' => ['multiple' => false, 'placeholder' => Yii::t('gmv', 'Select province')]
            ]);?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <?= $form->field($model, 'postal_code')->textInput() ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <?=  $form->field($model, 'country')->widget(Select2::classname(), [
                'name' => 'country',
                'class' => 'form-group country_ids form-control',
                'value' => ArrayHelper::map($countries, 'country_cod', function ($country) {
                    return $country['country_cod'];
                }),
                'id' => 'country',
                'data' => ArrayHelper::map($countries, 'country_cod', function ($country) {
                    return $country['description'];
                }),
                'options' => ['multiple' => false, 'placeholder' => Yii::t('gmv', 'Select country')]
            ]);?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <?= $form->field($model, 'shipping_address')->widget(Select2::classname(), [
                'name' => 'shipping_address',
                'class' => 'form-group shipping_address_ids form-control',
                'value' => ArrayHelper::map($shippingAddress, 'shipping_address_cod', function ($shippingAddress) {
                    return $shippingAddress['shipping_address_cod'];
                }),
                'id' => 'shipping_address_ids',
                'data' => ArrayHelper::map($shippingAddress, 'shipping_address_cod', function ($shippingAddress) {
                    return $shippingAddress['business_name_address']." - ".$shippingAddress['address']." - ".$shippingAddress['locality'];
                }),
                'options' => ['multiple' => false]
            ]);?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <?= $form->field($model, 'delivery_date')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <?= $form->field($model, 'order_reference')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <?= $form->field($model, 'plant_reference')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    <div class="form-group">
        <?= Html::submitButton(Yii::t('gmv', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
