<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use kartik\select2\Select2;
use bitcream\gmvricambi\custom\common\models\Order;

/* @var $this yii\web\View */
/* @var $searchModel bitcream\gmvricambi\custom\backend\models\OrderSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('gmv', 'Orders');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="order-index">

    <?= $this->render('_breadcrumb',[
        'searchModel' => $searchModel,
        'dataProvider' => $dataProvider,
    ]) ?>

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a(Yii::t('gmv', 'Create Order'), ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php $form = ActiveForm::begin([
                'action' => ['index'],
                'method' => 'get'
            ]) ?>
            <div class="row">
                <div class="col-md-2">
                <?= Html::label("Status Order");
                    echo Select2::widget(['model' => $searchModel, 'attribute' => 'order_status', 'language' => 'uk', 'data' => ArrayHelper::map(Order::find()->where(['customer_cod' => $customerUser->customerCod, 'status' => '30'])->all(), 'order_status', 'order_status')]); ?>
                </div>
            </div>
            <br>
            <div class="row">
                <div class="col-md-2">
                <?= Html::label("Destination Order");
                    echo Select2::widget(['model' => $searchModel, 'attribute' => 'locality', 'language' => 'uk', 'data' => ArrayHelper::map(Order::find()->where(['customer_cod' => $customerUser->customerCod, 'status' => '30'])->all(), 'locality', 'locality')]); ?>
                </div>
            </div>
            <br>
            <?= Html::submitButton('Filtra', ['class' => 'btn btn-success']) ?>
            <?= Html::a('Reset filtri', ['/custom/order-customer/index'], ['class'=>'btn btn-primary']) ?>
    <?php ActiveForm::end(); ?>
    <br>

    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= $this->render('_datatable',[
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
    ]) ?>


</div>
