<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use bitcream\gmvricambi\custom\common\widget\ActionWidget;

/* @var $this yii\web\View */
/* @var $model bitcream\gmvricambi\custom\backend\models\Order */

$this->title = $model->name;
$this->params['breadcrumbs'][] = ['label' => Yii::t('gmv', 'Orders'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="order-view">

    <h1><?= Html::encode($this->title) ?></h1>
    <?php
        
        $actionButtons =  [
            [
                'type' => 'update',
            ],
            [
                'type' => 'delete',
            ],
            [
                'type' => 'custom',
                'title' => Yii::t('gmv', 'Confirm'),
                'url' => '#',
                'warning-level' => 'success',
            ],
           
        ];
        if($customerUser->getActiveOrder()->id != $model->id){
            $activeButton = [
                'type' => 'custom',
                'title' => Yii::t('gmv', 'Active order'),
                'url' => ['activate-order', 'id' => $model->id],
                'warning-level' => 'primary',
            ];
            array_push($actionButtons, $activeButton);
        }
        echo ActionWidget::widget(['model' => $model, 'customButtons' => $actionButtons, 'categoryMessage' => 'gmv']);
    ?>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'name',
            'order_date',
            'address',
            'locality',
            'postal_code',
            'country',
            'shipping_address',
            'delivery_date',
            'payment_method',
            'customer_cod',
        ],
    ]) ?>

    <?= $this->render('_datatable-orderitem',[
            'searchModel' => $searchModelOrderItem,
            'dataProvider' => $dataProviderOrderItem,
            'order' => $model,
    ]) ?>

</div>
