<?php

use yii\widgets\Breadcrumbs;
use yii\helpers\Html;
use emberware\evidia\datatable\common\models\DataTableCustom;
use bitcream\gmvricambi\custom\common\models\CustomerUser;

?>
<div class="datatable">
        <?=
        DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            'id' => 'order-status',
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => [
                ['attribute'=>Yii::t('gmv', 'Name'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a($data->name, [Yii::$app->controller->id.'/view','id'=>$data->id]);}
                ],
                'order_status',
                [
                    'format'=>'raw',
                    'label' => 'Azioni',
                    'value' => function ($data)
                    {
                        $htmlButtons = "";
                        $htmlButtons .= " ".Html::a(Yii::t('gmv', '<i class="fa fa-pencil"></i>'), ['order-customer/update', 'id'=> $data->id], ['class' => 'btn btn-warning action-button']);
                        $htmlButtons .= " ".Html::a(Yii::t('gmv', '<i class="fa fa-trash"></i>'), ['order-customer/delete', 'id'=> $data->id], [
                                'class' => 'btn btn-danger action-button',
                                'data' => [
                                    'confirm' => Yii::t('gmv','Are you sure you want to delete this order?'),
                                    'method' => 'post',
                                ]
                        ]);
                        $orderActive = CustomerUser::getCurrentUser()->getActiveOrder();  
                        if(!isset($orderActive) || $orderActive->id != $data->id){
                            $htmlButtons .= " ".Html::a(Yii::t('gmv', '<i class="fa fa-star-o"></i>'), ['order-customer/activate-order', 'id'=> $data->id], ['class' => 'btn btn-success action-button']);
                        }else{
                            $htmlButtons .= " ".Html::a(Yii::t('gmv', '<i class="fa fa-star"></i>'), ['#'], ['class' => 'btn btn-success action-button']);
                        }                      
                        
                        $htmlButtons .= " ".Html::a(Yii::t('gmv', '<i class="fa fa-share-square-o"></i>'), ['order-customer/sent-gmv', 'id'=> $data->id], ['class' => 'btn btn-default action-button']);
                        $htmlButtons .= " ".Html::a(Yii::t('gmv', '<i class="fa fa-eur"></i>'), ['order-customer/pay', 'id'=> $data->id], ['class' => 'btn btn-primary action-button']);
                        return $htmlButtons;
                    }
                ]
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('gmv',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
    ?>
</div>