<?php

use yii\widgets\Breadcrumbs;
use yii\helpers\Html;
use emberware\evidia\datatable\common\models\DataTableCustom;

?>
<div class="datatable">
        <?=
        DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            'id' => 'order-status',
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => [
                'name',
                [
                    'format'=>'raw',
                    'label' => 'Azioni',
                    'value' => function ($data)
                    {
                        return Html::a(Yii::t('gmv', '<i class="fa fa-eye"></i>'), ['order-customer/view', 'id'=> $data->id], ['class' => 'btn btn-primary action-button']);
                    }
                ]
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('gmv',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
    ?>
</div>