<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use bitcream\gmvricambi\custom\common\widget\AddProductWidget;
use bitcream\gmvricambi\custom\common\widget\ActiveOrderWidget;


/* @var $this yii\web\View */
/* @var $model bitcream\gmvricambi\custom\backend\models\Product */

$this->title = $model->name;
$this->params['breadcrumbs'][] = ['label' => Yii::t('gmv', 'Products'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="product-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'name',
            'description:ntext',
            'detail:ntext',
            'article_cod',
            // 'category_id',
        ],
    ]) ?>

    <?= AddProductWidget::widget(['productModel' => $model, 'orderItemModel' => $orderItem]); ?>

</div>
<?= ActiveOrderWidget::widget(); ?>
