<?php

namespace bitcream\gmvricambi\custom\common\models;

use Yii;
use emberware\evidia\useroptions\common\models\UserOption;
use Emberware\Evidia\Model\GotifySender\utils\Gotify;
/**
 * This is the model class for table "{{%user}}".
 * @property GMVCustomer $customer
 * @property Order $activeOrder
 * @property String $customerCod
 */
class CustomerUser extends \emberware\evidia\users\common\models\User
{

    /**
     * Gets query for [[Customer]].
     *
     * @return GMVCustomer
     */
    public function getCustomer()
    {
        // return $this->hasMany(Store::className(), ['store_manager_id' => 'id'])->inverseOf('storeManager');
        $customer_cod = $this->customerCod;

        return  GMVCustomer::find()->where(['customer_cod' => $customer_cod])->one();
    }

    public function getCustomerCod(){
        return UserOption::getUserOption("customer_cod", $this);
    }

    public function setCustomerCod(String $customerCod){
        UserOption::setUserOptionNewUser("customer_cod", $customerCod, $this);
        return true;
    }
    /**
     * Set for [[Customer]].
     *
     * @return boolean
     */
    public function setCustomer(GMVCustomer $customer)
    {
       $this->setCustomerCod($customer->customer_cod);
        // UserOption::setUserOptionNewUser("customer_cod", , $this);
        return true;
    }

    /**
     * Gets query for [[ActiveOrder]].
     *
     * @return Order
     */
    public function getActiveOrder()
    {
        $active_order = UserOption::getUserOption("active_order_id", $this);

        return  Order::find()->where(['id' => $active_order])->one();    }

    /**
     * Set for [[ActiveOrder]].
     *
     * @return bool
     */
    public function setActiveOrder(Order $order)
    {
        $this->unsetActiveOrder($order->id);
        UserOption::setUserOptionNewUser("active_order_id", $order->id, $this);
        $title = "Activate order";
        $message = $title." id:".$order->id;
        $extra = [
            'messageType' => 'activateOrder', // da inserire come parametro del behaviors
            'objectUpdated' => json_encode($order), //restituisce o tutto l'oggetto o la struttura api dell'oggetto
            'objectId' => $order->id,
            'objectClass' => "",
            'action' => 'activeOrder',
            'event' => 'activeOrder',
            'changeAttribute' => "",
            'callUserId' => Yii::$app->user->id,
        ];

        Gotify::sendMessage($title, $message, $extra);
        return true;
    }

    /**
     * Set for [[ActiveOrder]].
     *
     * @return bool
     */
    public function setClosedOrder(Order $order)
    {
        UserOption::setUserOptionNewUser("active_order_id", $order->id, $this);
        $title = "Closed order sent to GMV";
        $message = $title." id:".$order->id;
        $extra = [
            'messageType' => 'closedOrder', // da inserire come parametro del behaviors
            'objectUpdated' => json_encode($order), //restituisce o tutto l'oggetto o la struttura api dell'oggetto
            'objectId' => $order->id,
            'objectClass' => "",
            'action' => 'closedOrder',
            'event' => 'closedOrder',
            'changeAttribute' => "",
            'callUserId' => Yii::$app->user->id,
        ];

        Gotify::sendMessage($title, $message, $extra);
        return true;
    }

    /**
     * Set for [[ActiveOrder]].
     *
     * @return bool
     */
    public function unsetActiveOrder($id)
    {
        $activeOrder = UserOption::find()->where(['user_id' => Yii::$app->user->id, 'field' => 'active_order_id'])->one();
        if($activeOrder){
            $activeOrder->delete();
        }        
        return true;
    }

    public static function getCurrentUser(){

        return CustomerUser::findOne(Yii::$app->user->id);
    }

}
