<?php

namespace bitcream\gmvricambi\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%GMV_list}}".
 *
 * @property string $price_list_cod
 * @property string $customer_cod
 * @property string $article_cod
 * @property float|null $quantity
 * @property float|null $price
 * @property float $price_1
 * @property float $price_2
 * @property float $price_3
 * @property float $price_4
 * @property float $price_5
 * @property string|null $currency
 */
class GMVList extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%GMV_list}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['price_list_cod', 'customer_cod', 'article_cod', 'price_1', 'price_2', 'price_3', 'price_4', 'price_5'], 'required'],
            [['quantity', 'price', 'price_1', 'price_2', 'price_3', 'price_4', 'price_5'], 'number'],
            [['price_list_cod'], 'string', 'max' => 1],
            [['customer_cod'], 'string', 'max' => 6],
            [['article_cod'], 'string', 'max' => 15],
            [['currency'], 'string', 'max' => 3],
            [['price_list_cod', 'customer_cod', 'article_cod'], 'unique', 'targetAttribute' => ['price_list_cod', 'customer_cod', 'article_cod']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'price_list_cod' => Yii::t('gmv', 'Price List Cod'),
            'customer_cod' => Yii::t('gmv', 'Customer Cod'),
            'article_cod' => Yii::t('gmv', 'Article Cod'),
            'quantity' => Yii::t('gmv', 'Quantity'),
            'price' => Yii::t('gmv', 'Price'),
            'price_1' => Yii::t('gmv', 'Price 1'),
            'price_2' => Yii::t('gmv', 'Price 2'),
            'price_3' => Yii::t('gmv', 'Price 3'),
            'price_4' => Yii::t('gmv', 'Price 4'),
            'price_5' => Yii::t('gmv', 'Price 5'),
            'currency' => Yii::t('gmv', 'Currency'),
        ];
    }
}
