<?php
namespace bitcream\gmvricambi\custom\common\widget;

use yii\base\Widget;
use yii\helpers\Html;
use Yii;
use bitcream\gmvricambi\custom\common\widget\AssetWidget;
use bitcream\gmvricambi\custom\common\models\UserOption;
use Emberware\Evidia\Field\FlagIcon\FlagIcon;

class ActionWidget extends Widget
{
    public $model;
    public $customButtons;
    public $categoryMessage;

    public function init()
    {
        parent::init();
        AssetWidget::register($this->getView());
    }

    public function run()
    {
        $htmlButtons = "<div class='action-box'>";
        foreach($this->customButtons as $customButton){
            switch ($customButton["type"]) {
                case 'create':
                    $htmlButtons .= Html::a(Yii::t($this->categoryMessage, 'Create'), ['create'], ['class' => 'btn btn-success action-button']);
                    break;
                case 'create-it':
                    $flag = FlagIcon::widget([
                        'countryCode' => "it",
                        'options' => [
                            'class' => 'flag-button'
                        ]
                        
                    ]);
                    $htmlButtons .= Html::a(Yii::t($this->categoryMessage, 'Create {flag}', ['flag' => $flag]), ['create', 'lang_create' => 'it'], ['class' => 'btn btn-success action-button']);
                    break;
                case 'create-en':
                    $flag = FlagIcon::widget([
                        'countryCode' => "gb",
                        'options' => [
                            'class' => 'flag-button'
                        ]
                    ]);
                        $htmlButtons .= Html::a(Yii::t($this->categoryMessage, 'Create {flag}', ['flag' => $flag]), ['create', 'lang_create' => 'en'], ['class' => 'btn btn-success action-button']);
                    break;
                case 'view':
                    $htmlButtons .= Html::a(Yii::t($this->categoryMessage, 'View'), ['view', 'id' => $this->model->id], ['class' => 'btn btn-success action-button']);
                    break;
                case 'update':
                    $htmlButtons .= Html::a(Yii::t($this->categoryMessage, 'Update'), ['update', 'id' => $this->model->id], ['class' => 'btn btn-warning action-button']);
                    break;
                case 'delete':
                    $htmlButtons .= Html::a(Yii::t($this->categoryMessage, 'Delete'), ['delete', 'id' => $this->model->id], [
                        'class' => 'btn btn-danger action-button',
                        'data' => [
                            'confirm' => 'Are you sure you want to delete this '.Yii::$app->controller->id.'?',
                            'method' => 'post',
                        ],
                    ]);
                    break;
                case 'custom':
                    $custom_params = ['class' => 'btn btn-'.$customButton['warning-level'].' action-button'];
                    if(array_key_exists('options', $customButton) && !empty($customButton['options'])){
                        $custom_params =array_merge($custom_params ,$customButton['options']);
                    }
                    $htmlButtons .= Html::a(Yii::t($this->categoryMessage, $customButton['title']), $customButton['url'], $custom_params);
                    break;
                case 'save':
                    $htmlButtons .= Html::submitButton(Yii::t($this->categoryMessage, 'Save'), ['class' => 'btn btn-warning action-button']);
                    break;
                case 'back':
                    $htmlButtons .= Html::a(Yii::t($this->categoryMessage, 'Back'), ['index'], ['class' => 'btn btn-primary action-button']);
                    break;
                default:
                    # code...
                    break;
            }
        }
        $htmlButtons .= "</div>";
        return $htmlButtons;
    }
}
?>
