<?php
namespace bitcream\gmvricambi\custom\common\widget;

use yii\base\Widget;
use yii\helpers\Html;
use Yii;
use yii\widgets\ActiveForm;
use kartik\touchspin\TouchSpin;

class AddProductWidget extends Widget
{

    public $productModel;
    public $orderItemModel;

    public function init()
    {
        parent::init();
        AssetWidget::register($this->getView());
    }

    public function run()
    {
        $form = ActiveForm::begin([
            'action' => ['add-product-to-order'],
            'method' => 'post',
        ]);

        echo "<div class='row'>";
            echo "<div class='col-md-5'>";
                echo "<div class='label-add-product'>".Yii::t('gmv', 'To purchase this product, you must enter the plant code')."</div>";
                echo "<div class='row'>";
                    echo "<div class='col-md-12'>";
                        echo $form->field($this->productModel, 'id')->hiddenInput(['value'=> $this->productModel->id])->label(false);
                        echo $form->field($this->orderItemModel, 'plant_code')->textInput(['maxlength' => true]);
                    echo "</div>";
                echo "</div>";
                echo "<div class='row'>";
                    echo "<div class='col-md-6'>";
                        echo $form->field($this->orderItemModel, 'quantity')->widget(TouchSpin::classname(), [
                            'pluginOptions' => [
                                'buttonup_class' => 'btn btn-primary', 
                                'buttondown_class' => 'btn btn-primary', 
                                'buttonup_txt' => '<i class="fa fa-plus-circle"></i>', 
                                'buttondown_txt' => '<i class="fa fa-minus-circle"></i>',
                                'step' => 1,
                                'initval' => 1,
                            ]
                        ])->label(false);
                    echo "</div>";
                    echo "<div class='col-md-6'>";
                        echo Html::submitButton(Yii::t('gmv', 'Add to order'), ['class' => 'btn btn-default btn-block']);
                    echo "</div>";                    
                echo "</div>";
                echo "<div class='row'>";
                    echo "<div class='col-md-12'>";
                        echo "<span class='label label-success'>Disponibile</span>";
                    echo "</div>";
                echo "</div><br>";
            echo "</div>";
        echo "</div>";
        ActiveForm::end();
    }
}
