<?php

namespace bitcream\gmvricambi\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%category}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%GMV_Articles_Category}}`
 */
class M210924094028AddArticlesCategoryIdColumnToCategoryTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%category}}', 'articles_category_id', $this->integer()->notNull()->unique());

        // creates index for column `articles_category_id`
        $this->createIndex(
            '{{%idx-category-articles_category_id}}',
            '{{%category}}',
            'articles_category_id'
        );

        // add foreign key for table `{{%GMV_Articles_Category}}`
        $this->addForeignKey(
            '{{%fk-category-articles_category_id}}',
            '{{%category}}',
            'articles_category_id',
            '{{%GMV_Articles_Category}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%GMV_Articles_Category}}`
        $this->dropForeignKey(
            '{{%fk-category-articles_category_id}}',
            '{{%category}}'
        );

        // drops index for column `articles_category_id`
        $this->dropIndex(
            '{{%idx-category-articles_category_id}}',
            '{{%category}}'
        );

        $this->dropColumn('{{%category}}', 'articles_category_id');
    }
}
