$( document ).ready(function() {
    $(document).on('select2:open', () => {
        document.querySelector('.select2-search__field').focus();
    });

    if($("#order-address").val() == ""){
        $(".order-business-name").hide();
        $(".order-address").hide();
        $(".order-locality").hide();
        $(".order-province").hide();
        $(".order-postal_code").hide();
        $('.button-shipping').html('New shipping address');
    }else{
        $(".field-order-shipping_address").hide();
        $('.button-shipping').html('Select existing shipping address');
    }

    $('.button-shipping').click(function(){
        if($('#new-address').val() == 0){
            $(".order-business-name").show();
            $(".order-address").show();
            $(".order-locality").show();
            $(".order-province").show();
            $(".order-postal_code").show();
            $(".field-order-shipping_address").hide();
            $('.button-shipping').html('Select existing shipping address');
            $('#new-address').val(1);
        }else{
            $(".order-business-name").hide();
            $(".order-address").hide();
            $(".order-locality").hide();
            $(".order-province").hide();
            $(".order-postal_code").hide();
            $(".field-order-shipping_address").show();
            if($("#order-address").val() == ""){
                $('.button-shipping').html('New shipping address');
            }else{
                $('.button-shipping').html('Update shipping address');
            }
            $('#new-address').val(0);
        }        
    });

    //Add product in order with ajax
    $('#add-product-action-modal').click(function(){
        $.ajax({
            type: 'POST',
            url: 'add-product-to-order',
            data: $("#form-add-product").serialize(),
            dataType: "json",
            success:function(response){
                if(response['result']){
                    $("#plant_code").val("");
                    $("#quantity-touchspin").val("1");
                    $("#quantity-number-disp").val("");
                    $('#modal-add-product').modal('hide');
                }               
            },
            error: function(response) {
                console.log("not added");
            }
        });
    });

    $('.popup-modal-add-product').click(function(e) {
        e.preventDefault();
        $(".touchspin").show();
        $(".number").show();
        $(".label-dimension").show();
        $(".label-quantity").show();
        var unitOfMeasure = $(this).data('name');
        var articleCod = $(this).data('id');
        $('#article_cod').val(articleCod);

        if(unitOfMeasure == true){
            //show float
            $(".touchspin").hide();
            $(".label-quantity").hide();
        }else{
            //show integer
            $(".number").hide();
            $(".label-dimension").hide();
        }
        $('.article_cod').html(articleCod);
        var modal = $('#modal-add-product').modal('show');
    });

    $('#orderStatus').on('change', function() {
        var url = $(this).val(); // get selected value
        if (url) { // require a URL
            window.location = "set-status?status="+this.value; // redirect
        }
        return false;
    });

    if(window.location.href.indexOf("#confirm")> -1){
        $('#modal-confirm').modal('show');
    }

    $('.popup-modal').click(function(e) {
        e.preventDefault();
        var modal = $('#modal-confirm').modal('show');
    });
});




