<?php

namespace bitcream\gmvricambi\custom\backend\controllers;

use Yii;
use bitcream\gmvricambi\custom\backend\models\GMVAssembledArticle;
use bitcream\gmvricambi\custom\backend\models\GMVAssembledArticleSearch;
use bitcream\gmvricambi\custom\backend\models\ProductComponentSearch;
use bitcream\gmvricambi\custom\backend\models\ProductImage;
use bitcream\gmvricambi\custom\backend\models\ProductComponent;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * GmvAssembledArticleController implements the CRUD actions for GMVAssembledArticle model.
 */
class GmvAssembledArticleController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all GMVAssembledArticle models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new GMVAssembledArticleSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single GMVAssembledArticle model.
     * @param string $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($article_cod)
    {
        $searchModelProductComponent = new ProductComponentSearch();
        $dataProviderProductComponent = $searchModelProductComponent->search(Yii::$app->request->queryParams);

        return $this->render('view', [
            'model' => $this->findModel($article_cod),
            'searchModelProductComponent' => $searchModelProductComponent,
            'dataProviderProductComponent' => $dataProviderProductComponent,
            'productImage' => ProductImage::getProductImage($article_cod),
            'components' => ProductComponent::getComponents($article_cod),
        ]);
    }

    /**
     * Creates a new GMVAssembledArticle model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new GMVAssembledArticle();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->article_cod]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing GMVAssembledArticle model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param string $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->article_cod]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing GMVAssembledArticle model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param string $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the GMVAssembledArticle model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param string $id
     * @return GMVAssembledArticle the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = GMVAssembledArticle::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('gmv', 'The requested page does not exist.'));
    }
}
