<?php

namespace bitcream\gmvricambi\custom\backend\models;

use Yii;
use bitcream\gmvricambi\custom\backend\models\Product;
use bitcream\gmvricambi\custom\common\models\CustomerUser;
/**
 * This is the model class for table "{{%GMV_article}}".
 *
 */
class GMVArticle extends \bitcream\gmvricambi\custom\common\models\GMVArticle
{
  /**
     * Gets query for [[Product]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getProducts()
    {
        return $this->hasMany(Product::className(), ['article_cod' => 'article_cod']);
    }


     /**
     * Se c'è traduzione carico Product translation
     * Se non c'è traduzione carico GMV Article
     */
    public function getAttributeTranslation(){        
        $customerUser = CustomerUser::findOne(Yii::$app->user->id);
        $language = $customerUser->customer->language;        
        $products = Product::find()->where(['article_cod' => $this->article_cod, 'status' => '30'])->all();        

        if(empty($products)){
            return [
                'model' => $this,
                'attributes' => [
                    'article_cod',
                    'description',
                    'family',
                    'unit_of_measure_cod',
                    'unit_of_measure',
                    'weight',
                    'packaging_code',
                    'assembled_product',
                ]                
            ];
        }

        $product = Product::getTranslation($language, $this->article_cod, $products);     
        return [
            'model' => $product,
            'attributes' => [
                'article_cod',
                'name',
                'description',
                'detail',
            ]
        ];
    }
}
