<?php

namespace bitcream\gmvricambi\custom\backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use bitcream\gmvricambi\custom\backend\models\GMVArticle;
use bitcream\gmvricambi\custom\common\models\CustomerUser;

/**
 * GMVArticleSearch represents the model behind the search form of `bitcream\gmvricambi\custom\backend\models\GMVArticle`.
 */
class GMVArticleSearch extends GMVArticle
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['article_cod', 'description', 'family', 'unit_of_measure_cod', 'unit_of_measure', 'packaging_code', 'assembled_product'], 'safe'],
            [['weight'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = GMVArticle::find();
        $customerUser = CustomerUser::findOne(Yii::$app->user->id);
        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if($customerUser->articleCodSelected){
            $query->andFilterWhere(
                ['like', 'article_cod', $customerUser->articleCodSelected]
            );
        }else{
            $query->where('0=1');
            return $dataProvider; 
        }

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'weight' => $this->weight,
        ]);

        

        // grid filtering conditions
        $query->andFilterWhere(['<>', 'assembled_product', 6]);


        $query->andFilterWhere(['like', 'article_cod', $this->article_cod])
            ->andFilterWhere(['like', 'description', $this->description])
            ->andFilterWhere(['like', 'family', $this->family])
            ->andFilterWhere(['like', 'unit_of_measure_cod', $this->unit_of_measure_cod])
            ->andFilterWhere(['like', 'unit_of_measure', $this->unit_of_measure])
            ->andFilterWhere(['like', 'packaging_code', $this->packaging_code])
            ->andFilterWhere(['like', 'assembled_product', $this->assembled_product]);

        return $dataProvider;
    }
}
