<?php

use yii\widgets\Breadcrumbs;
use yii\helpers\Html;
use emberware\evidia\datatable\common\models\DataTableCustom;
use Emberware\Evidia\Field\FlagIcon\FlagIcon;

?>
<div class="datatable">
        <?=
        DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            'id' => 'category-table',
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => [
                ['attribute'=>Yii::t('gmv', 'Name'),
                    'format'=>'raw',
                    'value' => function($data)
                    {
                        $lang = $data->getLanguageObject();
                        if($lang){
                            if($lang->label == "en"){
                                $country = "gb";
                            }else{
                                $country = $lang->label;
                            }
                            $flag = FlagIcon::widget([
                                'countryCode' => $country,
                                'options' => [
                                    'class' => 'flag-button'
                                ]
                            ]);
                            return Html::a($flag." ".$data->name, [Yii::$app->controller->id.'/update','id'=>$data->id]);
    
                        }else{
                            return Html::a($data->name, [Yii::$app->controller->id.'/update','id'=>$data->id]);
                        }                    }
                ],
                [
                    'class' => '\yii\grid\ActionColumn',
                    'header' => Yii::t('gmv', 'Actions'),
                    'visibleButtons' => ['delete' => true, 'update' => false, 'view' => false],
                ]
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('gmv',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
    ?>
</div>