<?php

use yii\widgets\Breadcrumbs;
use yii\helpers\Html;
use emberware\evidia\datatable\common\models\DataTableCustom;
use bitcream\gmvricambi\custom\backend\models\ProductImage;
?>
<div class="datatable">
        <?=
        DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            'id' => 'category-table',
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => [
                ['attribute'=>Yii::t('gmv', 'Article cod'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a($data->article_cod, [Yii::$app->controller->id.'/view','article_cod'=>$data->article_cod]);}
                ],
                'assembled_product',
                [
                    'format'=>'raw',
                    'label' => 'Azioni',
                    'value' => function ($data)
                    {
                        //Get product with article_cod
                        $htmlButtons = "";
                        // $model->products;
                        $productImage = ProductImage::find()->where(['article_cod' => $data->article_cod])->one();
                        if(!isset($productImage->article_cod)){
                            $htmlButtons .= " ".Html::a(Yii::t('gmv', '<i class="fa fa-plus"></i> <i class="fa fa-picture-o"></i>'), ['product-image/create', 'article' => $data->article_cod, 'controller'=>Yii::$app->controller->id], ['class' => 'btn btn-primary action-button']);
                        }else{
                            $htmlButtons .= " ".Html::a(Yii::t('gmv', '<i class="fa fa-pencil"></i> <i class="fa fa-picture-o"></i>'), ['product-image/update', 'article' => $data->article_cod, 'id'=> $productImage->id, 'controller'=>Yii::$app->controller->id], ['class' => 'btn btn-primary action-button']);
                            $htmlButtons .= " ".Html::a(Yii::t('gmv', '<i class="fa fa-trash-o"></i> <i class="fa fa-picture-o"></i>'), ['product-image/delete', 'id'=> $productImage->id, 'controller'=>Yii::$app->controller->id], [
                                'class' => 'btn btn-danger action-button',
                                'data' => [
                                    'confirm' => Yii::t('gmv','Are you sure you want to delete this product image?'),
                                    'method' => 'post',
                                ]
                            ]);
                        }
                        return $htmlButtons;
                    }
                ],
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('gmv',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
    ?>
</div>