<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use bitcream\gmvricambi\custom\common\widget\OrderActionWidget;
use yii\bootstrap\Modal;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model bitcream\gmvricambi\custom\backend\models\Order */
bitcream\gmvricambi\custom\backend\Asset::register($this);
$this->title = $model->name;
$this->params['breadcrumbs'][] = ['label' => Yii::t('gmv', 'Orders'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="order-view">

    <h1><?= Html::encode($this->title) ?></h1>
    <?php
        echo OrderActionWidget::widget(['status' => $status, 'model' => $model, 'activeOrder' => $customerUser->getActiveOrder(), 'categoryMessage' => 'gmv']);
    ?>

    
        <?php Modal::begin([
            'header' => '<h2 class="modal-title">'.Yii::t('gmv', 'Are you sure to confirm the order?').'</h2>',
            'id'     => 'modal-confirm',
        ]); ?>

            <?php $form = ActiveForm::begin([
                    'action' => ['confirm', 'id' => $model->id],
                    'method' => 'post', 
                ]
            ); ?>

                <?= '<h4>'.Yii::t('gmv','Once the order has been confirmed, you not be able to change the order!').'</h4><br>'; ?>
                <?= '<div class="row">
                        <div class="col-sm-6">
                            <b>'.Yii::t('gmv','Shipping address').'</b>
                            <br><p>'.$model->address.' '.$model->province.' '.$model->postal_code.'</p>
                        </div>
                        <div class="col-sm-6">
                            <b>'.Yii::t('gmv','Delivery date').'</b>
                            <br><p>'.$model->delivery_date.'</p>
                        </div>
                    </div><br>'; ?>
                <?= '<div class="row">
                        <div class="col-sm-12">
                            <b>'.Yii::t('gmv','Select Payment Method').'</b><br>'
                            ?><?=  Select2::widget([
                                'name' => 'payment_method',
                                'data' => ArrayHelper::map($paymentMethods,'payment_cod','description'),
                                'options' => [
                                    'placeholder' => Yii::t('gmv','Select payment method'),
                                    'multiple' => false
                                ],
                            ]);                
                            ?>
                            
                        </div>
                    </div>
                <?= '<h3>'.Yii::t('gmv','Total: ').$model->total.'€</h3>'; ?>
                <?=Html::submitButton(Yii::t('gmv','Confirm'), ['class' => 'btn btn-success', 'id' => 'confirm'])?>

            <?php ActiveForm::end(); ?>

        <?php Modal::end(); ?>
    

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'name',
            'order_date',
            'business_name',
            'address',
            'locality',
            'postal_code',
            'country',
            'shipping_address',
            'delivery_date',
            'payment_method',
            'customer_cod',
            'order_status',
        ],
    ]) ?>
    <br>
    <hr>

    <?php if($model->checkProcessing()){ 
            if(isset($customerUser->getActiveOrder()->id) && ($customerUser->getActiveOrder()->id  == $model->id)){ 
                echo Html::a(Yii::t('gmv','Add products to order'), ['gmv-article-customer/index'], ['class' => 'btn btn-success']);
            }else{
                echo Html::a(Yii::t('gmv','Activate and add products to order'), ['activate-add-product-order', 'id' => $model->id], ['class' => 'btn btn-success']);
            }
        } ?>
    <?= $this->render('_datatable-orderitem',[
            'searchModel' => $searchModelOrderItem,
            'dataProvider' => $dataProviderOrderItem,
            'order' => $model,
    ]) ?>
    

</div>
